; JFW 3.31 script file for Microsoft Excel
; Copyright 1998-1999 by Henter-Joyce, Inc.
; J K Stephen (formerly Dunn): Build xl3311337 30 August 1999
; Excel 95 (and earlier) support only

include "excelall.jsh"
include "excel95.jsh" ; constants and globals specific to Excel 95 or earlier
include "excelall.jsm" ; common Excel messages
include "excel95.jsm" ; Excel 95 messages only
Include "hjglobal.jsh"
include "hjconst.jsh"

Function AutoStartEvent ()
if (ExcelFirstTime == beginner) then
	let ExcelFirstTime = 1
	if GetVerbosity() == beginner then
		Say (msg50, OT_HELP) ;"Use Insert plus the letter H for help in various dialog boxes"
	EndIf ; verbosity beginner
endif ; first time
EndFunction





Script ScriptFileName ()
ScriptAndAppNames(msg168) ; "Excel 95 or earlier"
EndScript

Script SayPriorLine ()
var
	int TheTypeCode

PriorLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if (GetWindowClass (GetFocus ()) == wc9) then
	if (MenusActive () == False) then
		if (GetVerbosity() == beginner) Then
			ReadCell()
		endif
		if (IsFormulaCell ()) then
			SayUsingVoice (vctx_message,msg352a, OT_BUFFER); "has formula"
		endif
		SayFocusRect(GetFocus())
		PCCursor()
		return
	endif; menus not active
endif; in main spread sheet
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayNextLine ()
var
	int TheTypeCode
NextLine()

if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if (GetWindowClass (GetFocus ()) == wc9) then
	if (MenusActive () == False) then
		if (GetVerbosity() == 0) Then
			ReadCell()
		endif
		if (IsFormulaCell ()) then
			SayUsingVoice (vctx_message,msg352a, OT_BUFFER); "has formula"
		endif
		SayFocusRect(GetFocus())
		PCCursor()
		return
	endif; menus not active
endif; in main spread sheet
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script SayPriorCharacter ()
var
	int TheTypeCode
PriorCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if (GetWindowClass (GetFocus ()) == wc9) then
	if (MenusActive () == False) then
		if (GetVerbosity() == 0) Then
			ReadCell()
		endif
		if (IsFormulaCell ()) then
			SayUsingVoice (vctx_message,msg352a, OT_BUFFER); "has formula"
		endif
		SayFocusRect(GetFocus())
		PCCursor()
		return
	endif ; menus not active
endif ; in main spread sheet
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say (msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayNextCharacter ()
var
	int TheTypeCode
NextCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if (GetWindowClass (GetFocus ()) == wc9) then
	if (MenusActive () == False) then
		if (GetVerbosity() == 0) Then
			ReadCell()
		endif
		if (IsFormulaCell ()) then
			SayUsingVoice (vctx_message,msg352a, OT_BUFFER); "has formula"
		endif
		SayFocusRect(GetFocus ())
		PCCursor()
		return
	endif ; menus not active
endif ; in main spread sheet
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		Say (msg3, OT_MESSAGE) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		Say (msg4, OT_MESSAGE) ;"Start Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		Say (msg5, OT_MESSAGE) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

script SayCharacter ()
if IsPCCursor () then
	if (GetWindowClass (GetFocus ()) == wc9) then
		if (GlobalMenuMode == MENU_INACTIVE) then
			if (IsFormulaCell ()) then
				SayUsingVoice (vctx_message,msg352a, OT_BUFFER) ; "equals"
			endif
			SayFocusRect(GetFocus())
			return
		endif ; menus not active
	endif ; in main spread sheet
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord() ; says the current setting
		return
	endif
EndIf
if (IsSameScript ()) then
	SayCharacterPhonetic ()
	AddHook (HK_SCRIPT, "PhoneticSpellHook")
else
	SayCharacter()
EndIf
EndScript

Script JawsHome ()
JawsHome()
Pause()
Say (msg27, OT_MESSAGE) ;"home"
if IsPCCursor()then
	ReadCell ()
	SayCharacter()
EndIf
EndScript

Script JAWSEnd ()
;toggles you in and out of "end" mode
if IsJAWSCursor () then
	Say (msg28, OT_MESSAGE) ;"End"
EndIf
JAWSEnd ()
if getWindowclass(getFocus()) !=wc9 then
; not relevant
	return
endIf
if IsPCCursor () then
	SaveCursor ()
	InvisibleCursor ()
	if FindString(ExcelStatusHandle, msg28,s_bottom,s_restricted) then ;"End"
		If(GetVerbosity() == beginner) Then
			Say (msg29, OT_MESSAGE) ;"press any arrow key to move to end of data in current row or column"
		else
			Say (msg30, OT_MESSAGE) ;"press any arrow key"
		EndIf
	else
		Say (msg31, OT_MESSAGE) ;"End is off"
	EndIf
EndIf
EndScript

Script JawsPageUp ()
Say (msg23, OT_MESSAGE) ;"PageUp"
JAWSPageUp ()
Pause ()
if IsPCCursor()then
	ReadCell()
	PerformScript SayCharacter()
EndIf
EndScript

Script JawsPageDown ()
Say (msg24, OT_MESSAGE) ;"PageDown"
JAWSPageDown ()
Pause ()
if IsPCCursor()then
	ReadCell()
	PerformScript SayCharacter()
EndIf
EndScript

Script MoveToFirstCell ()
{Control + Home}
pause()
Say (msg18, OT_MESSAGE) ;"First cell"
ReadCell()
PerformScript SayCharacter ()
EndScript

Script MoveToLastCell ()
{Control + End}
pause()
Say (msg19, OT_MESSAGE) ;"Last Cell"
pause ()
ReadCell()
PerformScript SayCharacter ()
EndScript

Script SayActiveCellCoordinates ()
var
	int currentSetting
let currentSetting = GetJCFOption (OPT_INCLUDE_GRAPHICS)
if (currentSetting) then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 0)
EndIf
SayWindow (GetCellCoordinateWindow (), read_everything)
SetJcfOption (OPT_INCLUDE_GRAPHICS, currentSetting)
EndScript

Void Function ReadCell ()
var
   HANDLE hWnd
;wn56="Spelling"
If ((GetWindowName (GetParent (GetFocus ())) == wn56)
;wn56="Spelling"
|| (GetWindowName (GetRealWindow (GetFocus ())) == wn56)) Then
	;fs123="Cell Value"
	IF (FindString (GetFocus (), fs123, S_BOTTOM, S_UNRESTRICTED)) then
		SayLine ()
	else
		Say (msg124, OT_MESSAGE) ;"not found"
	endif ; find string
endif ; in spell checker
PerformScript sayActiveCellCoordinates()
EndFunction

Script SaySelectedText ()
;reads highlighted cells including the one with focus
var
	handle WinHandle
let WinHandle = GetFocus ()
if (GetWindowClass (WinHandle) == wc9) then
	if (GlobalMenuMode == MENU_INACTIVE) then
		if (GetVerbosity() == beginner) Then
			Say (msg32, OT_MESSAGE) ;"Say entire selected range visible on screen"
		endif
		if (GetVerbosity() == intermediate) Then
			Say (msg33, OT_MESSAGE) ;"selected range"
		endif
		SayFocusRect(WinHandle)
		return
	EndIf
EndIf
If (GetVerbosity() == beginner) Then
	Say (msg40, OT_MESSAGE) ;"Selected text is"
EndIf
SayWindow (GetCurrentWindow (), 1) ; say the highlighted text only
EndScript

Script ColumnFirstCellFromTop ()
;Used to read the cell at the top of the current column
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
If (ToggleRestriction () == OFF) then
	ToggleRestriction()
EndIf
JAWSPageUp ()
ToggleRestriction ()
NextLine ()
NextLine ()
PriorWord ()
NextWord ()
SayChunk ()
RestoreCursor ()
EndScript

Script ColumnSecondCellFromTop ()
;Used to read the second cell from the top of the current column
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
If (ToggleRestriction () == OFF) then
ToggleRestriction()
EndIf
JAWSPageUp ()
ToggleRestriction ()
NextLine ()
NextLine ()
NextLine ()
PriorWord ()
NextWord ()
SayChunk ()
RestoreCursor ()
EndScript

Script ColumnThirdCellFromTop ()
;Used to read the third cell from the top of the current column
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
If (ToggleRestriction () == OFF) then
ToggleRestriction()
EndIf
JAWSPageUp ()
ToggleRestriction ()
NextLine ()
NextLine ()
NextLine ()
NextLine ()
PriorWord ()
NextWord ()
SayChunk ()
RestoreCursor ()
EndScript

Script ColumnFourthCellFromTop ()
;Used to read the fourth cell from the top of the current column
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
If (ToggleRestriction () == OFF) then
ToggleRestriction()
EndIf
JAWSPageUp ()
ToggleRestriction ()
NextLine ()
NextLine ()
NextLine ()
NextLine ()
NextLine ()
PriorWord ()
NextWord ()
SayChunk ()
RestoreCursor ()
EndScript

Script RowFirstCellFromLeft ()
;Used to read the cell at the Left of the current row
SaveCursor()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
JAWSHome ()
NextChunk ()
SayChunk ()
RestoreCursor ()
EndScript

Script RowSecondCellFromLeft ()
;Used to read the cell second from the Left of the current row
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
JAWSHome ()
NextChunk ()
NextChunk ()
SayChunk ()
RestoreCursor ()
EndScript

Script RowThirdCellFromLeft ()
;Used to read the cell third from the Left of the current row
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
JAWSHome ()
NextChunk ()
NextChunk ()
NextChunk ()
SayChunk ()
RestoreCursor ()
EndScript

Script RowFourthCellFromLeft ()
;Used to read the cell fourth from the Left of the current row
SaveCursor ()
if (IsPCCursor ()) then
	RouteInvisibleToPc ()
endif
if (IsJAWSCursor ()) then
	RouteInvisibleToJAWS ()
endif
InvisibleCursor ()
JAWSHome ()
NextChunk ()
NextChunk ()
NextChunk ()
NextChunk ()
SayChunk ()
RestoreCursor ()
EndScript

Script ScreenSensitiveHelp ()
var
	String TheClass
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf

Let TheClass = GetWindowClass (GetCurrentWindow ())
; wc4="excel4"
if (TheClass == wc4) then
	Say (msg116, OT_HELP) ;"you are on a tool bar button"
	Say (msg117, OT_HELP) ;"press the control key to hear the label spoken"
	Say (msg118, OT_HELP) ;"click the left mouse to choose it"
	return
EndIf ; if "excel4" tool bar button
if (TheClass == wc9) then
	Say (msg119, OT_HELP) ;"This is the spread sheet area"
	return
EndIf ; Main Grid
PerformScript ScreenSensitiveHelp ()
EndScript

Script HotKeyHelp ()
;wc5="bosa_sdm_XL"
if (GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc5)
;wc3="edtbx"
|| (GetWindowClass (GetRealWindow (GetCurrentWindow ())) == wc3 ) then
;wn56="Spelling"
	if (GetWindowName (GetRealWindow (GetFocus())) == wn56)
;wn56="Spelling"
	|| (GetWindowName (GetParent (GetFocus())) == wn56) then
		Say (msg57, OT_HELP) ;"type in a replacement word and then enter"
		Say (msg58, OT_HELP) ;" or use one of the following options"
		Say (msg59, OT_HELP) ;"To hear the misspelled word and suggestion use Insert plus F7"
		Say (msg61, OT_HELP) ;"Use the tab key or the following windows hot keys"
		Say (msg62, OT_HELP) ;"To move to suggestions list box use Alt N"
		Say (msg63, OT_HELP) ;"To return to Change to: edit box use Alt T"
		Say (msg64, OT_HELP) ;"To Choose the ignore option use Alt I"
		Say (msg65, OT_HELP) ;"To choose the ignore all option use Alt G"
		Say (msg66, OT_HELP) ;"To except the reccommended change use Alt C"
		Say (msg67, OT_HELP) ;"To except the reccommended change for all occurrances use Alt L"
		Say (msg68, OT_HELP) ;"To select the always suggest check box use Alt y"
		Say (msg69, OT_HELP) ;"To select the ignore uppercase check box use alt e"
		Say (msg70, OT_HELP) ;"To Add word to dictionary use Alt A"
		Say (msg71, OT_HELP) ;"To select a specific dictionary to add words use Alt W"
		Say (msg72, OT_HELP) ;"To undo last change use Alt U"
		Say (msg72b, OT_HELP);"To use auto correct use alt r"
		Say (msg73, OT_HELP) ;"For Help with spell checker use Alt H or escape to cancel"
		Return
	EndIf
	Say (msg706 + GetWindowName(GetRealWindow(GetFocus())) + msg707, OT_HELP)
	Say (msg708, OT_HELP) ; "Use tab and shift + tab to move between the controls"
	Say (msg709, OT_HELP) ; "Use insert + f1 for screen sensitive help"
	;take care of some known problematic dialogs.  If it is not problematic, then
	;use the HotKeyHelpDefaultLoop
	if (!ExcelHotKeyHelp()) then HotKeyHelpDefaultLoop () endif
	return
Else
	;msg760 = ". "
	Say (msg78+msg399+getScriptKeyName("WindowKeysHelp")+msg760, OT_HELP) ;"Use insert + w for a  list of some excel standard keyboard commands"
	Say (msg79 + GetScriptKeyName ("sayActiveCellCoordinates") + msg760, OT_HELP) ; "To hear the coordinates of current cell, use "
	Say (msg80, OT_HELP) ;"If you hear has formula when you move to a cell, use
	Say (GetScriptKeyName ("SayFormula")+msg81, OT_HELP) ;"To review the formula, use Control plus F2"
	Say (msg82, OT_HELP) ;"to review selected cells, use shift plus insert down arrow"
	Say (msg83, OT_HELP) ;"To hear the contents of the top 4 cells in the column"
	Say (msg84, OT_HELP) ;"Use the alt key with 1 through 4 on the number row"
	Say (msg85, OT_HELP) ;"To hear the contents of the 4 cells from the left margin"
	Say (msg86, OT_HELP) ;"Use the alt key with 5 through 8 on the number row"
EndIf
EndScript














String Function GetFormula ()
var
   HANDLE hWnd,
  String Formula

let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
while (hWnd)
;wc6="excel6"
   if (GetWindowClass(hWnd) == wc6) then
      Let Formula = GetTextBetween (GetWindowLeft(hwnd), GetWindowRight(hwnd))
JAWSCursor ()
MoveToWindow (hwnd)
PcCursor ()
   endif
    let hWnd = GetNextWindow(hWnd)
endwhile
Return Formula
EndFunction

Script SayFormula ()
if isSameScript() then
	messageBox(getFormula())
else
	say (getFormula(), OT_TEXT)
endIf
EndScript

Script SayBottomLineOfWindow ()
var
	HANDLE hWnd
let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
while (hWnd)
	if (GetWindowClass(hWnd) == wc8) then
		SayWindow(hWnd,0)
		return
	endif
	let hWnd = GetNextWindow(hWnd)
endwhile
EndScript

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1)
;wn92="#32771"
|| (TheClass == wn92 )) then
Say (buffer, OT_BUFFER)
return
EndIf
; status line
;wc8="excel8"
if TheClass== wc8  then
	Let ExcelStatusHandle = hwnd
;wn93="Edit"
   if (StringContains (buffer, wn93)) then
Say (buffer, OT_BUFFER) ; say edit
return
endif
return ; done with status line
endif ; excel8, status line

;say the formula on the tool bar
;wc6="excel6"
if (TheClass== wc6) then ; formula window
;wn94="="
   if (StringContains (buffer, wn94)) then ; formula
Say (msg95, OT_BUFFER) ;"equals"
endif ; = formula
return
endif ; excel6, formula
; say the text when entering edit window, F2
; spell checker
if (GlobalCurrentControl == 17) then
;wn56="Spelling"
if (GlobalRealWindowName == wn56) then
;wn97="Not in Dictionary"
if ((StringContains (buffer, wn97))
;wn98="Capitalization:"
|| (StringContains (buffer, wn98))
;wn99="Repeated Word:"
|| (StringContains (buffer, wn99))) then
delay (2)
PerformScript SpellCheck()
EndIf
EndIf
EndIf
EndFunction

String Function GetStaticText ()
var
handle hwnd,
string Text
SaveCursor()
InvisibleCursor()
let Text = ""
let hwnd = GetFocus()
;wc11 = "MSOUNISTAT"
while (hwnd && GetWindowClass(hwnd) != wc11)
let hwnd = GetNextWindow (hwnd)
endWhile

if (hwnd) then
	MoveToWindow(hwnd)
	let Text = GetChunk()
endif
return Text
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
HANDLE RealWindow,
string RealWindowName,
HANDLE AppWindow

let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
let GlobalFocusWindow = FocusWindow ; used by sdm routine

;wc10="_sdm_"
if (StringContains (GetWindowClass (RealWindow), wc10)) then
; we are in an SDM dialog
let GlobalRealWindow = RealWindow
let GlobalRealWindowName = RealWindowName
SaySDMFocusedWindow()
Else ; not sdm
;start of regular non-sdm logic
if (GlobalPrevApp != AppWindow
&& AppWindow != FocusWindow) then
; we've switched to a different app main window,
; and it does not have the focus, so announce it
SayWindowTypeAndText(AppWindow)
endif

If ((GlobalPrevRealName != RealWindowName) ; name has changed
|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
If ((RealWindow != AppWindow)
&& (RealWindow != FocusWindow)) then
SayWindowTypeAndText(RealWindow)
endif
EndIf
; now say the window with focus
	SayFocusedWindow()
EndIf ;end else sdm
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function SaySDMFocusedWindow ()
; called by focus changed, to handle sdm dialogs
;Say (msg748, OT_DEBUG) ; "entering sdm"
let GlobalCurrentControl = SdmGetFocus (GlobalFocusWindow)
;wn56="Spelling"
if ((GlobalRealWindowName == wn56)
&& (GlobalCurrentControl == 17)) then
; highlighted text event says the mispelled word
return
endif ; spell dialog box on "word not found"
; If we've just entered a new real window say it
If (GlobalPrevReal != GlobalRealWindow)
|| GlobalRealWindowName != GlobalPrevRealName then
; the handles could be the same, check names?
SayWindowTypeAndText (GlobalRealWindow) ; dialog box name
SdmSayStaticText (GlobalRealWindow) ;dialog box text
endif ; new real window handle or name
; now say the current control
SdmSayWindowTypeAndText (GlobalFocusWindow, GlobalCurrentControl)
EndFunction

void function SayHighlightedText (handle hwnd, string buffer)
if(GetScreenEcho() > 0) Then
	;wn56="Spelling"
	if ((GlobalRealWindowName == wn56)
		&& (GlobalCurrentControl == 17)) then
		return
	endif ; spell dialog box on "word not found"
	Say (buffer, OT_BUFFER) ; say the highlighted text
EndIf
EndFunction

Script  SpellCheck()
;wn56="Spelling"
If ((GetWindowName (GetParent (GetFocus ())) == wn56)
;wn56="Spelling"
|| (GetWindowName (GetRealWindow (GetFocus ())) == wn56)) Then
RouteInvisibleToPc()
InvisibleCursor()
JawsPageUp()
NextLine()
JawsHome()
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
NextWord () ; move onto the word
If (GetVerbosity () > beginner) then
SayWord ()
Else
SayLine ()
EndIf
SpellWord() ;spell it either way
; now see if there are any suggestions
;fs104="(No Suggestions)"
if (FindString (GetFocus (), fs104, s_top, s_unrestricted)) then
Say (msg105, OT_MESSAGE) ;"no suggestions"
else ; there are suggestions, read the first one
NextLine()
JAWSHome ()
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
;wn103=":"
if StringContains (GetWord (), wn103) then
else
NextWord ()
endif ; string contains :
NextWord () ; move onto the word
If (GetVerbosity () > beginner) then
SayWord ()
Else
SayLine()
EndIf ; verbosity beginner
SpellWord() ;spell it either way
endif ; finst string "no suggestions"
PcCursor()
Else
Say (msg106, OT_MESSAGE) ;"Not in spell checker"
EndIf
EndScript

Script DataRegionDown ()
;wc10="_sdm_"
if (StringContains (GetWindowClass (GetFocus ()), wc10)) then
; we are in an SDM dialog
SdmSayWindowTypeAndText (GetFocus (), SdmGetFocus (GetFocus ()))
; check boxes and radio buttons
if ((GetWindowTypeCode (GetFocus ())== WT_CHECKBOX)
|| (GetWindowTypeCode (GetFocus ())== WT_RADIOBUTTON)) then
SaveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
PriorWord ()
SayWord ()
return
endif ; check box
return
endif ; end if sdm
if (GetWindowClass (GetCurrentWindow ()) == wc9) then
	; if in Main Grid
	{Control + Down Arrow}
	Pause ()
	if IsPCCursor() then
		InvisibleCursor ()
		;fs47="Ready"
		if FindString(GetFocus(),fs47,0,0) then
			if (GetVerbosity() == 0) Then
				ReadCell()
				Say (msg48, OT_MESSAGE) ;"edge of current data region"
			endif
			SayFocusRect(GetFocus())
			PCCursor()
			return
		endif
		PCCursor ()
	endif
	if IsJawsCursor()
		|| IsInvisibleCursor()
		|| CaretVisible() then
		SayLine()
	endif
	return
endif ; Main Grid
SayControl (GetCurrentWindow ())
EndScript



Script  PriorSheet()
;switches to the prior sheet and reads the number
{control+pageup}
delay (1)
SaySheetName()
EndScript

Script  NextSheet()
;switches to the next sheet and reads the number
{control+pagedown}
delay (1)
SaySheetName()
EndScript

Void Function SaySheetName ()
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
if (FindLastAttribute (ATTRIB_BOLD)) then
	SayChunk ()
else
	Say (msg121, OT_MESSAGE) ;"bolded sheet tab not found"
endif ; bold not found
EndFunction

Script SayFocusRect ()
SayFocusRect (GetFocus ())
EndScript

Function CursorChangedEvent (string CursorType)
;CURSOR CHANGED EVENT Function
Let GlobalCursorType = CursorType
If (IsJAWSCursor ()) then
	If (CursorType == CT_UNKNOWN) then
		Say (msg122, OT_CURSOR) ;"Cross hair cursor"
		Return
	EndIf
	PerformScript SayCursorType ()
EndIf
EndFunction



Script AutoSum ()
;Used to autosum
{Alt+=}
If(GetVerbosity() == beginner) Then
Say (msg128, OT_MESSAGE) ;"Type in the range to Sum using colon to separate or"
Say (msg129, OT_MESSAGE) ;"Press enter to accept default range"
EndIf
If(GetVerbosity() == 1) Then
Say (msg130, OT_MESSAGE) ;"Type new range or Enter to accept"
EndIf
EndScript

Script BoldText ()
{control+b}
ReportFont (btnBold)
EndScript

Script ItalicText ()
{control+i}
ReportFont (btnItalic)
EndScript

Script UnderlineText ()
{control+u}
ReportFont (btnUnderline)
EndScript

Function ReportFont (string strButton)
; incomplete
sayFont()
EndFunction

Script  SayFont()
; Identify Font
SayFont ()
EndScript

Script  WindowKeysHelp()
Say (msg1 , OT_HELP) ;"The following are some of the Excel Keyboard shortcuts"
Say (msg2, OT_HELP) ;"Auto sum, use Alt plus equals"
Say (msg3, OT_HELP) ;"Go to a certain cell, use F5"
Say (msg4, OT_HELP) ;"to start a formula, use equals"
Say (msg5, OT_HELP) ;"Select the entire column, use control plus space bar"
Say (msg6, OT_HELP)  ;"Select the entire row, use shift plus space bar"
Say (msg7, OT_HELP) ;"use standard window selecting keystrokes to select specific cells"
Say (msg8, OT_HELP) ;"move to edge of data regions, use control and arrow keys"
Say (msg9, OT_HELP) ;"Switch sheets, use control and page up or down"
Say (msg10, OT_HELP) ;"Move left or right one screen, use Alt plus Page down or up"
Say (msg11, OT_HELP) ;"to move to the end of any row or column"
Say (msg12, OT_HELP) ;" use the end key then the arrow key in the desired direction"
Say (msg13, OT_HELP) ;"selecting text, use combinations of control and shift with arrows, home and end"
Say (msg14, OT_HELP) ;"Insert the date, use control plus semicolon"
Say (msg15, OT_HELP) ;"Insert the time, use Control plus shift plus semicolon"
EndScript





Script  FormulaMode()
var
string TheClass
let theClass=GetWindowClass(GetFocus())
{=}
; only want to say a msg if in worksheet area
if theClass==wc9 then
	;puts you in mode to type a formula
Say (msg20, OT_MESSAGE) ;"type in the formula and press enter"
else
	Say (msg95, OT_MESSAGE) ; equals
endIf
EndScript

Script  DateStamp()
;inserts date in cell
{Control + ;}
Say (msg21, OT_MESSAGE) ;"Inserted date"
If(GetVerbosity() == 0) Then
         SayCharacter()
EndIf
EndScript

Script  TimeStamp()
;inserts time in cell
{Control + Shift + ;}
Say (msg22, OT_MESSAGE) ;"Inserted time"
If(GetVerbosity() == 0) Then
         SayCharacter()
EndIf
EndScript

Script ScreenLeft ()
;moves one screen to left
{Alt+PageUp}
pause()
If(GetVerbosity() == beginner) Then
Say (msg25, OT_MESSAGE) ;"Moved left one screen"
EndIf
         ReadCell()
         SayCharacter()
EndScript

Script ScreenRight ()
;moves one screen to right
{Alt+PageDown}
pause()
If(GetVerbosity() == beginner) Then
Say (msg26, OT_MESSAGE) ;"Moved right one screen"
EndIf
         ReadCell()
         SayCharacter()
EndScript





Script  SelectFromStartOfLine()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectFromStartOfLine() ; default
	return
endIf
;extends selection to left margin
SelectingText (TRUE)
{Shift+Home}
Let SelDir = 0
Let nMode = 2
SelectingText (FALSE)
Say (msg34, OT_MESSAGE) ;"Extends the selection to beginning of row"
performScript saySelectedText()
EndScript

Script  SelectNextLine()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectNextLine()
	return
endIf
SelectingText (TRUE)
SelectNextLine ()
Let SelDir = 1
Let nMode = 2
SelectingText (FALSE)
performScript saySelectedText()
EndScript

Script  SelectPriorLine()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectPriorLine()
	return
endIf
SelectingText (TRUE)
SelectPriorLine ()
Let SelDir = 0
Let nMode = 2
SelectingText (FALSE)
;Say (msg35, OT_MESSAGE) ;"select range"
performScript saySelectedText()
EndScript

Script  SelectNextCharacter()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectNextCharacter()
	return
endIf
SelectingText (TRUE)
SelectNextCharacter ()
Let SelDir = 1
Let nMode = 2
SelectingText (FALSE)
performScript saySelectedText()
EndScript

Script  SelectPriorCharacter()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectPriorCharacter()
	return
endIf
SelectingText (TRUE)
SelectPriorCharacter ()
Let SelDir = 0
Let nMode = 2
SelectingText (FALSE)
;Say (msg35, OT_MESSAGE) ;"select range"
performScript saySelectedText()
EndScript

Script  SelectNextWord()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectNextWord()
	return
endIf
;selects range to right margin
SelectingText (TRUE)
{Control+Shift+RightArrow}
Let SelDir = 1
Let nMode = 2
SelectingText (FALSE)
Say (msg36, OT_MESSAGE) ;"select range to right Margin"
performScript saySelectedText()
EndScript

Script  SelectPriorWord()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectPriorWord()
	return
endIf
;selects range to left margin
SelectingText (TRUE)
{Control+Shift+LeftArrow}
Let SelDir = 0
Let nMode = 2
SelectingText (FALSE)
Say (msg37, OT_MESSAGE) ;"select range to Left Margin"
performScript saySelectedText()
EndScript

Script  SelectFromTop()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectFromTop()
	return
endIf
;selects to first cell in worksheet
SelectingText (TRUE)
SelectFromTop()
Let SelDir = 0
Let nMode = 2
SelectingText (FALSE)
Say (msg38, OT_MESSAGE) ;"extends selection to first cell in worksheet, Top left"
performScript saySelectedText()
EndScript

Script  SelectToBottom()
if GetWindowTypeCode(GetFocus())==wt_edit then
; perform default function
	performScript selectToBottom()
	return
endIf
;selects to last cell in worksheet
SelectingText (TRUE)
SelectToBottom()
Let SelDir = 1
Let nMode = 2
SelectingText (FALSE)
Say (msg39, OT_MESSAGE) ;"extends selection to last cell in worksheet, Bottom Right"
performScript saySelectedText()
EndScript

Script  SelectRegion()
;selects current region
{Control+Shift+8}
Say (msg40, OT_MESSAGE) ;"Selected the current region"
performScript saySelectedText()
EndScript

Script  CopyToClipboard()
{Control + C}
If(GetVerbosity() == 0) Then
Say (msg41, OT_MESSAGE) ;"Copied selected range"
EndIf
If(GetVerbosity() == 1) Then
Say (msg42, OT_MESSAGE) ;"Copied"
EndIf
EndScript

Script  CutToClipboard()
{Control + X}
If(GetVerbosity() == 0) Then
Say (msg43, OT_MESSAGE) ;"Cut selected range"
EndIf
If(GetVerbosity() == 1) Then
Say (msg44, OT_MESSAGE) ;"Cut"
EndIf
EndScript

Script  PasteFromClipboard()
{Control + V}
Say (msg45, OT_MESSAGE) ;"Pasted selected range"
If(GetVerbosity() == 1) Then
Say (msg46, OT_MESSAGE) ;"Pasted"
EndIf
EndScript

Script  DataRegionUp()
;moves up to edge of current data region
{Control + Up Arrow}
Pause ()
if IsPCCursor() then
   InvisibleCursor ()
;fs47="Ready"
   if FindString(GetFocus(),fs47,0,0) then
      if (GetVerbosity() == 0) Then
         ReadCell()
         Say (msg48, OT_MESSAGE) ;"edge of current data region"
      endif
      SayFocusRect(GetFocus())
      PCCursor()
      return
   endif
endif
if IsJawsCursor()
|| IsInvisibleCursor()
|| CaretVisible() then
  SayLine()
endif
EndScript

Script  DataRegionRight()
;moves to edge of data region
{Control + Right Arrow}
Pause ()
if IsPCCursor() then
   InvisibleCursor ()
;fs47="Ready"
   if FindString(GetFocus(),fs47,0,0) then
      if (GetVerbosity() == 0) Then
         ReadCell()
         Say (msg48, OT_MESSAGE) ;"edge of current data region"
      endif
      SayFocusRect(GetFocus())
      PCCursor()
      return
   endif
endif
if IsJawsCursor()
|| IsInvisibleCursor()
|| CaretVisible() then
  SayLine()
endif
EndScript

Script  DataRegionLeft()
;moves to edge of data region
{Control+Left Arrow}
Pause ()
if IsPCCursor() then
   InvisibleCursor ()
;fs47="Ready"
   if FindString(GetFocus(),fs47,0,0) then
      if (GetVerbosity() == 0) Then
         ReadCell()
         Say (msg48, OT_MESSAGE) ;"edge of current data region"
      endif
      SayFocusRect(GetFocus())
      PCCursor()
      return
   endif
endif
if IsJawsCursor()
|| IsInvisibleCursor()
|| CaretVisible() then
  SayLine()
endif
EndScript

Script  CollapseSelectionToActiveCell()
;collapses selection to active cell
{Shift+BackSpace}
Say (msg49, OT_MESSAGE) ;"collapses selection to active cell"
EndScript

Int Function IsSDMDialog ()
if (StringContains(GetWindowClass(GetRealWindow(GetCurrentWindow())), wc10)) then
	return TRUE
else
	return FALSE
endif
EndFunction

HANDLE Function GetCellCoordinateWindow ()
var
	HANDLE hWnd
let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
if (GetWindowClass (hWnd)==wc8) then
	let hWnd = GetNextWindow(hWnd)
endif
return hWnd
EndFunction

String Function GetCellCoordinates ()
var
	handle hWnd
SaveCursor()
InvisibleCursor()
let hWnd = GetCellCoordinateWindow ()
if (hWnd) then
	MoveToWindow(hWnd)
	return GetChunk()
endif
EndFunction

Void Function SayFocusedWindow ()
; edit window, excel7
;wc7="excel7"
if (GetWindowClass (GlobalFocusWindow) == wc7) then
SayWindow (GlobalFocusWindow, Read_Everything)
return
endif ; edit window, excel7

SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Int Function IsFormulaCell ()
var
   HANDLE hWnd,
   String Formula

SaveCursor ()
InvisibleCursor ()
let hWnd = GetAppMainWindow(GetFocus())
let hWnd = GetFirstChild(hWnd)
while (hWnd)
;wc6="excel6"
   if (GetWindowClass(hWnd) == wc6) then
	MoveToWindow(hWnd)
	let Formula = GetWord()
	;msg762 = "="
	if (StringContains(Formula, msg762) == 1) then
		return TRUE
	endif
   endif
   let hWnd = GetNextWindow(hWnd)
endwhile
return FALSE
EndFunction

;***
;Excel 97 Script
;***

String Function ColumnNumberToLetter (int i)
var
	int quotient,
	int remainder1,
	int remainder2
let i = i-1
let quotient = (i)/26
let remainder1 = quotient%27
let remainder2 = i%26
return SubString (alphabet, remainder1 + 1, 1) + " " + SubString (alphabet, remainder2 + 2, 1)
EndFunction

Int Function IsDialog ()
;wc12 = "#32770"
if (GetWindowClass(GetRealWindow(GetCurrentWindow())) == wc12) then
	return TRUE
else
	return FALSE
endif
EndFunction

Void Function ExcelHotKeyHelp ()
var
String strRealName,
String strPage,
int bSuccess
let strRealName = GetWindowName (GetRealWindow (GetFocus ()))
if stringContains(strRealName, msg899) then
	return true
;wn104 = "Format Cells"
elif (strRealName == wn104) then
	let strPage = GetDialogPageName ()
	Say (msg713, OT_HELP)	 ; "hot keys are as follows"
	;wn105 = "Number"
	if (strPage == wn105) then
		Say (msg714, OT_HELP)	; "category use alt c"
	;wn106 = "Alignment"
	elif (strPage == wn106) then
		Say (msg715, OT_STRING) ; "horizontal group"
		Say (msg716, OT_HELP) ; "general use alt g"
		Say (msg717, OT_HELP) ; "left use alt l"
		Say (msg718, OT_HELP) ; "center use alt c"
		Say (msg719, OT_HELP) ; "right use alt r"
		Say (msg720, OT_HELP) ; "fill use alt f"
		Say (msg721, OT_HELP) ; "justify use alt j"
		Say (msg722, OT_HELP) ; "center across selection use alt a"
		Say (msg723, OT_HELP) ; "vertical group"
		Say (msg724, OT_HELP) ; "top use alt t"
		Say (msg725, OT_HELP) ; "center use alt e"
		Say (msg726, OT_HELP)
		Say (msg727, OT_HELP) ; "justify use alt u"
		Say (msg728, OT_HELP) ; "wrap text use alt e"
		Say (msg729, OT_HELP) ; "orientation use alt n"
	;wn108 = "Font"
	elif (strPage == wn108) then
		Say (msg730, OT_HELP) ; "Font use alt f"
		Say (msg731, OT_HELP) ; "Font styles use alt o"
		Say (msg732, OT_HELP) ; "size use alt s"
		Say (msg733, OT_HELP) ; "strike through use alt k"
		Say (msg734, OT_HELP) ; "Superscript use alt e"
		Say (msg735, OT_HELP) ; "Subscript use alt b"
		Say (msg736, OT_HELP) ; "Underline use alt u"
		Say (msg739, OT_HELP) ; "Color use alt c"
		Say (msg737, OT_HELP) ; "Normal font use alt n"
	;wn109 = "Border"
	elif (strPage == wn109) then
		Say (msg738, OT_HELP) ; "Style group use alt e"
		Say (msg739, OT_HELP) ; "color use alt c"
		Say (msg740, OT_HELP) ; "border group"
		Say (msg741, OT_HELP) ; "outline use alt o"
		Say (msg742, OT_HELP) ; "left user alt l"
		Say (msg719, OT_HELP) ; "right use alt r"
		Say (msg724, OT_HELP) ; "top use alt t"
		Say (msg726, OT_HELP) ; "bottom use alt b"
	;wn110 = "Patterns"
	elif (strPage == wn110) then
		Say (msg743, OT_HELP)	; "Color palet use alt c"
		Say (msg744, OT_HELP) ; "pattern use alt p"
	;wn111 = "Protection"
	elif (strPage == wn111) then
		Say (msg745, OT_HELP) ; "locked use alt l"
		Say (msg746, OT_HELP) ; "hidden use alt i"
	endif
	return TRUE
else
	return FALSE
endif
EndFunction

Function GetRealWindow (handle hwnd)
;wn112 = "Print"
if (GetWindowName(GetTopLevelWindow(GetFocus())) == wn112) then
	return GetTopLevelWindow(hwnd)
else
	return GetRealWindow(hwnd)
endif
EndFunction

int Function BrailleBuildCell ()
If (GetWindowClass(GetFocus()) == wc9) Then  ; Build the line in spread sheet window
  BrailleAddString(GetCellCoordinates(),0,0,0)
  ;msg764 = ": "
  BrailleAddString(msg764,0,0,0)
  BrailleAddString(GetTextInFocusRects (GetFocus()),0,0,0)
  If IsFormulaCell95() Then
    BrailleAddString(msg762,0,0,0)
    BrailleAddString(GetFormula(),0,0,0)
  EndIf
  Return True
Else
  Return False
EndIf
EndFunction

int Function BrailleBuildLine ()
if not BrailleBuildLine() then
	return brailleBuildCell()
endIf
EndFunction
Script TabKey ()
{tab}
pause()
performScript sayActiveCellCoordinates()
performScript sayCharacter()
EndScript

Script backTabKey ()
{shift+tab}
pause()
performScript sayActiveCellCoordinates()
performScript sayCharacter()
EndScript

Function Unknown (string TheName, int IsScript)
say(msg131,ot_help) ; this feature is unavailable in this version of Excel.
EndFunction

script sayExcelVersion()
say(msg168,ot_message) ; Excel 95 or earlier
endScript